<?php $data = \Asylum\Utility\Arr::undot($data); ?>
<ul class="sortable ag-region__list">
    <?php foreach ($data['region'] ?? [] as $code => $region) : ?>
        <li class="ag-region">
            <input type="hidden" name="ag_settings[region][<?php echo $code; ?>][type]" value="<?php echo $region['type']; ?>" />
            <div class="ag-region__handle">
                <span class="dashicons dashicons-editor-justify"></span>
            </div>
            <div class="ag-region__field-group">
                <div>
                    <label class="ag-region__label"><?php _e('Region name', 'age-gate-region'); ?></label>
                    <input type="text" name="ag_settings[region][<?php echo $code; ?>][title]" class="regular-text ltr ag-region__field ag-region__field--title" value="<?php echo $region['title']; ?>" required />
                </div>
                <?php if ($languages ?? false) : ?>
                    <button class="ag-region__translation-toggle button-link" type="button"><?php _e('Translations', 'age-gate-region'); ?></button>
                    <div class="ag-region__translations">
                        <p><small><?php _e('Translations are not required. Default name will be used.', 'age-gate-region'); ?></small></p>
                        <?php foreach ($languages['available'] as $language) : ?>
                            <div class="ag-region__translation">
                                <img src="<?=$language['flag'] ?>">
                                <input type="text" name="ag_settings[region][<?php echo $code; ?>][title_<?=$language['code'] ?>]" class="regular-text ltr ag-region__field ag-region__field--title ag-region__field--title--lang" value="<?php echo $region['title_' . $language['code']] ?? ''; ?>" />
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="ag-region__field-group">
                <label class="ag-region__label"><?php _e('Region code', 'age-gate-region'); ?></label>
                <input type="text" name="ag_settings[region][<?php echo $code; ?>][code]" class="small-text ltr ag-region__code" value="<?php echo $region['code']; ?>" required />
            </div>
            <div class="ag-region__field-group">
                <label class="ag-region__label"><?php _e('Restriction age', 'age-gate-region'); ?></label>
                <input type="number" name="ag_settings[region][<?php echo $code; ?>][age]" class="small-text ltr" value="<?php echo $region['age']; ?>" required />
            </div>
            <div class="ag-region__field-group">
                <label class="ag-region__label"><?php _e('Redirect on success', 'age-gate-region'); ?></label>
                <select name="ag_settings[region][<?php echo $code; ?>][redirect]" class="regular-text ltr ag-redirect-type">
                    <option value=""<?php echo(empty($region['redirect']) ? ' selected' : ''); ?>><?php _e('Current page', 'age-gate-region'); ?></option>
                    <?php if ($languages && $region['type'] === 'lang') : ?>
                        <?php $url = ($code !== $languages['default']['code'] ? $languages['available'][$code]['url'] ?? null : $languages['default']['url'] ?? null); ?>
                        <?php if ($url) : ?>
                            <option value="<?php echo $url; ?>"<?php echo($region['redirect'] === $url ? ' selected' : ''); ?>><?php _e('Language landing', 'age-gate-region'); ?></option>
                        <?php endif; ?>
                    <?php endif; ?>
                    <option value="custom"<?php echo($region['redirect'] === 'custom' ? ' selected' : ''); ?>><?php _e('Custom', 'age-gate-region'); ?></option>
                </select>
                <div class="ag-region__subfield<?php echo $region['redirect'] !== 'custom' ? ' hidden' : ''; ?>">
                    <label class="ag-region__label"><?php _e('Custom redirect URL', 'age-gate-region'); ?></label>
                    <input type="url" name="ag_settings[region][<?php echo $code; ?>][custom_redirect]" class="regular-text ltr ag-region__custom" value="<?php echo isset($region['custom_redirect']) ? $region['custom_redirect'] : ''; ?>"<?php echo $region['redirect'] !== 'custom' ? ' disabled' : ''; ?> required />
                </div>
            </div>
            <div class="ag-region__field-group ag-region__field--checkbox">
                <label class="ag-region__label"><input type="checkbox" name="ag_settings[region][<?php echo $code; ?>][default]" class="ag-region__default" value="1" <?php echo isset($region['default']) && $region['default'] ? ' checked' : ''; ?> /> <?php _e('Set as default', 'age-gate-region'); ?></label>
            </div>
            <div class="ag-region__actions">
                <button type="button" class="ag-region__action ag-region__action--remove"><span class="dashicons dashicons-remove"></span></button>
                <?php /*
                <!-- <button type="button" class="ag-region__action ag-region__action--children"><span class="dashicons dashicons-download"></span></button> -->
                <!-- <button type="button" class="ag-region__action ag-region__action--add"><span class="dashicons dashicons-insert"></span></button> -->
                */ ?>
            </div>
        </li>
    <?php endforeach; ?>
</ul>
