<?php

namespace AgeGate\UserRegistration\Integration;

use Asylum\Validation\Validator;
use Asylum\Utility\StringTemplate;
use AgeGate\Common\Settings as CoreSettings;
use AgeGate\UserRegistration\Settings\Settings;

class Buddypress extends AbstractIntegration
{
    public function __construct()
    {
        add_action( 'bp_signup_profile_fields', [$this, 'fields']);
		add_action( 'bp_signup_validate', [$this, 'validate']);
    }

    public function validate()
	{

        $settings = Settings::getInstance();

        if (!$settings->restrictRegister) {
            return;
        }

        $validation = new Validator;
        $data = $validation->sanitize($_POST);

        if (!isset($data['age_gate'])) {
            return;
        }

        $validated = Validator::is_valid($data['age_gate'], array(
            'd' => 'required|numeric|min_len,2|max_len,2|max_numeric,31',
            'm' => 'required|numeric|min_len,2|max_len,2|max_numeric,12',
            'y' => 'required|numeric|min_len,4|max_len,4|max_numeric,' . date('Y'),
        ));


        if ($validated !== true) {
            $core = CoreSettings::getInstance();
            global $bp;
            $bp->signup->errors['age_gate'] = sprintf($settings->registrationError, $settings->age ?: $core->defaultAge);
        }
	}



}
