<?php

namespace AgeGate\UserRegistration\Enqueue;

class Enqueue
{
    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'assets']);
        add_action('admin_enqueue_scripts', [$this, 'admin']);
        add_action('login_enqueue_scripts', [$this, 'assets']);
    }

    public function assets()
    {
        wp_enqueue_style('age-gate-user-registration', AGE_GATE_USER_REGISTRATION_URL . 'dist/main.css', [], AGE_GATE_USER_REGISTRATION_VERSION);


    }

    public function admin()
    {
        global $pagenow;
        switch ($pagenow) {
            case 'user-new.php':
            case 'profile.php':
            case 'user-edit.php':
                wp_enqueue_style('age-gate-user-registration', AGE_GATE_USER_REGISTRATION_URL . 'dist/main.css', [], AGE_GATE_USER_REGISTRATION_VERSION);
                break;
        }
    }
}
