<?php

namespace AgeGate\UserRegistration\Admin\Controller;

use AgeGate\Common\Admin\AbstractController;
use AgeGate\Common\Immutable\Constants as Immutable;
use AgeGate\UserRegistration\Admin\Settings\Registration;

class RegistrationController extends AbstractController
{
    use Registration;

    const PERMISSION = Immutable::RESTRICTIONS;
    const OPTION = 'wp_age_gate_addon_age-gate-user-registration';

    public function register() : void
    {
        $this->menu(__('Registration', 'age-gate'), self::PERMISSION);
    }

    protected function required() : bool
    {
        return true;
    }

    protected function data() : array
    {
        return get_option(self::OPTION, []) ?: [];;
    }

    protected function fields(): array
    {
        return $this->getRegistrationFields();
    }

}
